import ProductCardRowStyleOne from "./Cards/ProductCardRowStyleOne";
import DataIteration from "./DataIteration";

export default function SectionStyleTwo({ className, products }) {
  const rs = products.map((item) => {
    return {
      id: item.id,
      title: item.name,
      slug: item.slug,
      image: process.env.NEXT_PUBLIC_BASE_URL + item.thumb_image,
      price: item.price,
      offer_price: item.offer_price,
      campaingn_product: null,
      review: parseInt(item.averageRating),
      variants: item.active_variants,
    };
  });
  return (
    <div
      className={`section-content w-full grid lg:grid-cols-2 xl:grid-cols-3 grid-cols-1 xl:gap-[30px] gap-5 ${
        className || ""
      }`}
    >
      <DataIteration
        datas={rs}
        startLength={0}
        endLength={rs.length > 6 ? 6 : rs.length}
      >
        {({ datas }) => (
          <div key={datas.id} className="item w-full">
            <ProductCardRowStyleOne datas={datas} />
          </div>
        )}
      </DataIteration>
    </div>
  );
}
